#include <stdlib.h>
#include <string.h>
#include "global.h"
#include "utils.h"
#include "routine.h"
#include "ext_basic.h"
#include "routine_composite.h"

ROUTINE *routines=NULL;
long routines_size;
long routines_free;



void init_routines(void)
{
routines_size=20;
routines_free=0;
routines=do_alloc(routines_size,sizeof(ROUTINE));
init_ext_basic();
}

void reset_routines(void)
{
long i;
for(i=routines_free-1;i>=0;i--)
	if(!(routines[i].type & ROUTINE_BUILTIN))delete_routine(i);
}

void delete_routine(long i)
{
long k;
routines_free--;
free(routines[i].name);
free(routines[i].comment);
free(routines[i].param_type);
free(routines[i].data);
for(k=i;k<routines_free;k++)memcpy(&(routines[k]),&(routines[k+1]),sizeof(ROUTINE));
}

void expand_routines(void)
{
long i;
ROUTINE *r;

r=do_alloc(routines_size*2,sizeof(ROUTINE));
for(i=0;i<routines_free;i++)memcpy(&r[i],&routines[i],sizeof(ROUTINE));
free(routines);
routines=r;
routines_size=routines_size*2;
}

void add_routine(char *name,char *comment, long type, long result,long param_count,u64 *param_type, void * execute , void *data)
{
if(routines_free+1>=routines_size)expand_routines();
routines[routines_free].type=type;
routines[routines_free].name=strdup(name);
routines[routines_free].comment=strdup(comment);
routines[routines_free].result=result;
routines[routines_free].param_count=param_count;
routines[routines_free].param_type=param_type;
routines[routines_free].execute=execute;
routines[routines_free].data=data;
routines_free++;
}

char * routine_type(long l)
{
switch(l & 0xFFFF){
	case ROUTINE_COMPOSITE: return "composite";
	case ROUTINE_BUILTIN:   return "builtin";
	default:	
		return "unknown";
	}
}


void dump_routine(FILE *fout,ROUTINE *r)
{
long i;
ATTRIBUTE *a;
ROUTINE *r1;
switch(r->type){
	case ROUTINE_CUSTOMIZED:
		fprintf(fout,"routine \"%s\" from ",r->name);
		if(r->data!=NULL)
			fprintf(fout,"\"%s\"\n",((ROUTINE *)r->data)->name);
			else fprintf(fout,"\"abstact\"\n");
		if(r->comment!=NULL)fprintf(fout,"\tcomment \"%s\"\n",r->comment);
		fprintf(fout,"\tparameters");
		for(i=0;i<r->param_count;i++){
			switch(((ROUTINE *)r->data)->param_type[i]){
				case TYPE_ATTR:
					a=get_attribute(r->param_type[i]);
					if(a!=NULL)
						fprintf(fout," \"%s\"",a->name);
						else
						fprintf(fout," \"attr_unknown\"");
					break;
				case TYPE_FUNC:
					r1=get_routine(r->param_type[i]);
					if(r1!=NULL)
						fprintf(fout," {%s}",r1->name);
						else
						fprintf(fout," {abstract}");
					break;
				default:
					fprintf(fout," %lld",r->param_type[i]);
					break;
				}
			}
		fprintf(fout,"\n");
		fprintf(fout,"end\n");
		break;
	case ROUTINE_COMPOSITE:
		fprintf(fout,"routine \"%s\" composite\n",r->name);
		if(r->comment!=NULL)fprintf(fout,"\tcomment \"%s\"\n",r->comment);
		fprintf(fout,"\tcode \"");
		dump_operation(fout,(OPT *)r->data);
		fprintf(fout,"\"\n");
		fprintf(fout,"end\n");
		break;
	case ROUTINE_BUILTIN:
	case ROUTINE_BUILTIN | ROUTINE_CUSTOMIZED:
		break;
	default:
		break;
	}
}

void dump_routines(FILE *fout)
{
long i;

for(i=0;i<routines_free;i++)
	if(!(routines[i].type & ROUTINE_BUILTIN))
		dump_routine(fout,&(routines[i]));
}

int execute_routine(ROUTINE *r,u64 *result)
{
if(r==NULL)return -1;
if(r->execute==NULL)return -1;
return r->execute(r,r->param_type,r->data,result);
}

int evaluate_routine(long index,u64 *result)
{
ROUTINE *r;
r=get_routine(index);
if(r==NULL)return -1;
if(r->execute==NULL)return -1;
return r->execute(r,r->param_type,r->data,result);
}

long get_routine_index(char *name)
{
long i;
for(i=0;i<routines_free;i++){
	if(!strcmp(routines[i].name,name))return i;
	}
return -1;
}

ROUTINE *get_routine(long index)
{
if(index<0)return NULL;
if(index>=routines_free)return NULL;
return &(routines[index]);
}

ROUTINE *add_new_customized_routine(char *name, char *from)
{
long ind;
ROUTINE *r;
ind=get_routine_index(from);
if(ind<0)return NULL;
if(routines_free+1>=routines_size)expand_routines();
r=&(routines[routines_free]);
routines_free++;
memcpy(r,&(routines[ind]),sizeof(ROUTINE));
r->data=(void *)&(routines[ind]);
r->param_type=do_alloc(r->param_count,sizeof(u64));
r->comment=strdup(r->comment);
r->type=ROUTINE_CUSTOMIZED;
r->name=strdup(name);
return r;
}

ROUTINE *add_new_composite_routine(char *name)
{
ROUTINE *r;
if(routines_free+1>=routines_size)expand_routines();
r=&(routines[routines_free]);
routines_free++;
r->data=NULL;
r->param_count=0;
r->param_type=NULL;
/*r->param_type=do_alloc(r->param_count,sizeof(u64)); */
r->comment=strdup("This is a composite routine");
r->type=ROUTINE_COMPOSITE;
r->execute=execute_composite;
r->name=strdup(name);
return r;
}

char *get_routine_name(long index)
{
ROUTINE *r;

r=get_routine(index);
if(r==NULL)return "routine_unknown";
return r->name;
}
